
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  CS4398.h: functions to communicate with and configure the CS4398 DAC IC via SPI
  Written by Nicholas Vinen, 2012-2013
*/

#ifndef _CS4398_H_
#define _CS4398_H_

#include "types.h"

#define CS4398_REG_CHIP_ID     0x01
#define CS4398_REG_MODE1       0x02
#define CS4398_REG_MIX         0x03
#define CS4398_REG_MUTEC       0x04
#define CS4398_REG_VOL_LEFT    0x05
#define CS4398_REG_VOL_RIGHT   0x06
#define CS4398_REG_RAMPFILTER  0x07
#define CS4398_REG_MISC        0x08
#define CS4398_CHIP_ID         0x70
#define CS4398_MODE1_DSD_SRC  (1<<7)
#define CS4398_MODE1_DIF_SHIFT    4
#define CS4398_MODE1_DIF_LJUST    0
#define CS4398_MODE1_DIF_I2S      1
#define CS4398_MODE1_DIF_RJUST16  2
#define CS4398_MODE1_DIF_RJUST24  3
#define CS4398_MODE1_DIF_RJUST20  4
#define CS4398_MODE1_DIF_RJUST18  5
#define CS4398_MODE1_DEM_SHIFT    2
#define CS4398_MODE1_DEM_NONE     0
#define CS4398_MODE1_DEM_44_1     1
#define CS4398_MODE1_DEM_48       2
#define CS4398_MODE1_DEM_32       3
#define CS4398_MODE1_FM_SHIFT     0
#define CS4398_MODE1_FM_SINGLE    0
#define CS4398_MODE1_FM_DOUBLE    1
#define CS4398_MODE1_FM_QUAD      2
#define CS4398_MODE1_FM_DSD       3
#define CS4398_MIX_SWAP_LR        6
#define CS4398_MIX_NORMAL         9
#define CS4398_MIX_MONO          15
#define CS4398_MIX_INVERT_POL    96
#define CS4398_MIX_LOCK_VOL     128
#define CS4398_MUTEC_PAMUTE   (1<<7)
#define CS4398_MUTEC_DAMUTE   (1<<6)
#define CS4398_MUTEC_MUTECAB  (1<<5)
#define CS4398_MUTEC_MUTE_A   (1<<4)
#define CS4398_MUTEC_MUTE_B   (1<<3)
#define CS4398_MUTEC_MUTEP_SHIFT  0
#define CS4398_MUTEC_MUTEP_AUTO   0
#define CS4398_MUTEC_MUTEP_ALOW   2
#define CS4398_MUTEC_MUTEP_AHIGH  3
#define CS4398_RAMP_DIRECTDSD (1<<0)
#define CS4398_RAMP_SLOW_FILT (1<<2)
#define CS4398_RAMP_DN_ERROR  (1<<4)
#define CS4398_RAMP_UP_ERROR  (1<<5)
#define CS4398_RAMP_IMMEDIATE (0<<6)
#define CS4398_RAMP_ZEROCROSS (1<<6)
#define CS4398_RAMP_SOFTRAMP  (2<<6)
#define CS4398_RAMP_SOFT_ZERO (3<<6)
#define CS4398_MISC_PDN       (1<<7)
#define CS4398_MISC_CPEN      (1<<6)
#define CS4398_MISC_FREEZE    (1<<5)
#define CS4398_MISC_MCLKDIV2  (1<<4)
#define CS4398_MISC_MCLKDIV3  (1<<3)


void CS4398_Setup();
void CS4398_HoldInReset();
void CS4398_ReleaseFromReset();
void CS4398_Write_Register(unsigned char addr, unsigned char data);
unsigned char CS4398_Read_Register(unsigned char addr);
void CS4398_Write_Registers(unsigned char addr, const unsigned char* data, unsigned char num);
void CS4398_Read_Registers(unsigned char addr, unsigned char* data, unsigned char num);

bool CS4398_Verify_ID();
void CS4398_Set_Volume_and_Balance(unsigned char Volume, signed char Balance);

#endif//_CS4398_H_
